////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

const char *NULLSTR = "NULL";
const int NULLSTRLEN = 4;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteNull(FILE *TargetHandle)
{
    fwrite(&NULLSTRLEN, sizeof(NULLSTRLEN), 1, TargetHandle);
    fwrite(NULLSTR, sizeof(char), NULLSTRLEN, TargetHandle);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void ReplaceSingleQuotes(SQLCHAR *Data, SQLINTEGER Length)
{
    int RPos = 0;

    while(RPos < Length)
    {
        if(Data[RPos] == '\'')
            Data[RPos] = '`';

        RPos++;
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

SQLINTEGER CharTrim(SQLCHAR *Data, SQLINTEGER Length)
{
    SQLINTEGER Pos = Length;

    if(Length == 0)
        return Length;

    if(Data[Length-1] != ' ')
        return Length;

    Pos--;

    while(Pos != 0 && Data[Pos] == ' ')
        Pos--;

    if(Data[Pos] != ' ')
        Pos++;

    Data[Pos] = '\0';

    return Pos;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ExportSQLResults(char *Driver, char *Server, char *UID, char *PWD, char *Database, char *Statement, char *ImportTable, char *OutFileName)
{
    SQLBasics LSQL;

    HSTMT StatementHandle;
    HSTMT UpdateStatementHandle;

    FILE *TargetHandle = NULL;

    char xStatement[255];
    char StatusText[1024];

    if(!LSQL.DBConnect(Driver, Server, UID, PWD, Database))
    {
        WriteLog("ExportSQLResults DBConnect: Fail.");
        return SQL_IMPORT_RESULT_ERROR;
    }

    sprintf(xStatement, "UPDATE %s SET Portal_Dirty = 1 WHERE Portal_Dirty = 2", ImportTable);
    if(!LSQL.DBExecute(xStatement, &UpdateStatementHandle))
    {
        sprintf(StatusText, "ExportSQLResults UPDATE DBexecute: Fail on (%s)", xStatement);
        WriteLog(StatusText);

        LSQL.DBDisconnect();
        return SQL_IMPORT_RESULT_ERROR;
    }
    DBCloseCursor(UpdateStatementHandle);

    if(!LSQL.DBExecute(Statement, &StatementHandle))
    {
        sprintf(StatusText, "ExportSQLResults SELECT DBexecute: Fail on (%s)", Statement);
        WriteLog(StatusText);

        LSQL.DBDisconnect();
        return SQL_IMPORT_RESULT_ERROR;
    }

    sprintf(xStatement, "UPDATE %s SET Portal_Dirty = 2 WHERE Portal_Dirty = 1", ImportTable);
    if(!LSQL.DBExecute(xStatement, &UpdateStatementHandle))
    {
        sprintf(StatusText, "UPDATE DBexecute: Fail on (%s)", xStatement);
        WriteLog(StatusText);

        DBCloseCursor(StatementHandle);
        LSQL.DBDisconnect();
        return SQL_IMPORT_RESULT_ERROR;
    }
    DBCloseCursor(UpdateStatementHandle);

    SQLSMALLINT outColumnCount = 0;
    if(SQLNumResultCols(StatementHandle, &outColumnCount) != SQL_SUCCESS)
    {
        WriteLog("SQLNumResultCols: Error.");

        DBCloseCursor(StatementHandle);
        LSQL.DBDisconnect();
        return SQL_IMPORT_RESULT_ERROR;
    }

    SQLINTEGER outRowCount = 0;
    if(SQLRowCount(StatementHandle, &outRowCount) != SQL_SUCCESS)
    {
        WriteLog("SQLRowCount: Error.");

        DBCloseCursor(StatementHandle);
        LSQL.DBDisconnect();
        return SQL_IMPORT_RESULT_ERROR;
    }

    if(outRowCount == 0)
    {
        sprintf(StatusText, "Query returned zero rows.");
        WriteLog(StatusText);

        DBCloseCursor(StatementHandle);
        LSQL.DBDisconnect();
        return SQL_IMPORT_RESULT_ZEROROWS;
    }
    else{
        sprintf(StatusText, "Query returned %d rows with %d columbs.", outRowCount, outColumnCount);
        WriteLog(StatusText);
    }

    if((TargetHandle = fopen(OutFileName, "wb")) == NULL)
    {
        sprintf(StatusText, "TargetFile: Binary write error with (%s).", OutFileName);
        WriteLog(StatusText);

        DBCloseCursor(StatementHandle);
        LSQL.DBDisconnect();
        return SQL_IMPORT_RESULT_ERROR;
    }

    int ImportTableNameLen = strlen(ImportTable);
    fwrite(&ImportTableNameLen, sizeof(ImportTableNameLen), 1, TargetHandle); // Write import table name len
    fwrite(ImportTable, sizeof(char), ImportTableNameLen, TargetHandle); // Write import table name
    fwrite(&outColumnCount, sizeof(outColumnCount), 1, TargetHandle); // Write number of columbs
    fwrite(&outRowCount, sizeof(outRowCount), 1, TargetHandle);       // Write number of rows

    //---------------( Get Columb Information )---
    SQLSMALLINT inColumnNameLen = 256;

	SQLUINTEGER outColumnSizePtr = 0;

    SQLSMALLINT outColumnNameLen = 0;
    SQLSMALLINT *outDataType = 0;
    SQLSMALLINT outDecimalDigitsPtr = 0;
    SQLSMALLINT outNullablePtr = 0;

    SQLCHAR outColumnName[256];

    SQLRETURN SQLResult = 0;

    int ColumbLoop = 0;

    outDataType = (SQLSMALLINT *) calloc( sizeof(SQLSMALLINT), outColumnCount);

    do{
        SQLResult = SQLDescribeCol(StatementHandle, ColumbLoop + 1, outColumnName, inColumnNameLen,
            &outColumnNameLen, &outDataType[ColumbLoop], &outColumnSizePtr, &outDecimalDigitsPtr, &outNullablePtr
        );

        if(SQLResult == SQL_SUCCESS)
        {
            fwrite(&outColumnNameLen, sizeof(outColumnNameLen), 1, TargetHandle);
            fwrite(outColumnName, sizeof(char), outColumnNameLen, TargetHandle);
        }
        ColumbLoop++;
    }
    while(SQLResult == SQL_SUCCESS);

    //---------------( Get Columb Data )---
    while(DBFetch(StatementHandle))
    {
        SQLINTEGER DataLength = 0;

        ColumbLoop = 0;
        while(ColumbLoop < outColumnCount)
        {
            SQLSMALLINT DataType = outDataType[ColumbLoop];

            if(DataType == SQL_CHAR || DataType == SQL_VARCHAR || DataType == SQL_LONGVARCHAR)
            {
                SQLCHAR SQLBuffer[1024];

                if(DBGetData(StatementHandle, ColumbLoop+1, SQL_C_CHAR, SQLBuffer, 1024, &DataLength))
                {
                    SQLBuffer[DataLength] = '\0';
                    if(DataLength == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
                        DataLength = CharTrim(SQLBuffer, DataLength);
                        ReplaceSingleQuotes(SQLBuffer, DataLength);

                        DataLength = (DataLength + 2); // To make room for the single quotes
                        fwrite(&DataLength, sizeof(DataLength), 1, TargetHandle);
                        DataLength = (DataLength - 2); // Because we only write the origional trimmed length

                        fwrite("'", 1, 1, TargetHandle); // Wrap the data in single quotes
                        fwrite(SQLBuffer, sizeof(char), DataLength, TargetHandle);
                        fwrite("'", 1, 1, TargetHandle); // Wrap the data in single quotes
                    }

                }
            }
            else if(DataType == SQL_TYPE_DATE || DataType == SQL_TYPE_TIME || DataType == SQL_TYPE_TIMESTAMP)
            {
                SQLCHAR SQLBuffer[255];

                if(DBGetData(StatementHandle, ColumbLoop+1, SQL_C_CHAR, SQLBuffer, 255, &DataLength))
                {
                    SQLBuffer[DataLength] = '\0';

                    if(DataLength == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
                        DataLength = CharTrim(SQLBuffer, DataLength);
                        ReplaceSingleQuotes(SQLBuffer, DataLength);

                        DataLength = (DataLength + 2); // To make room for the single quotes
                        fwrite(&DataLength, sizeof(DataLength), 1, TargetHandle);
                        DataLength = (DataLength - 2); // Because we only write the origional trimmed length

                        fwrite("'", 1, 1, TargetHandle); // Wrap the data in single quotes
                        fwrite(SQLBuffer, sizeof(char), DataLength, TargetHandle);
                        fwrite("'", 1, 1, TargetHandle); // Wrap the data in single quotes
                    }

                }
            }
            else if(DataType == SQL_INTEGER || SQL_DECIMAL || SQL_NUMERIC || SQL_SMALLINT || SQL_REAL)
            {
                SQLINTEGER SQLBuffer = 0;
                char CharData[32];

                if(DBGetData(StatementHandle, ColumbLoop+1, SQL_C_LONG, &SQLBuffer, 32, &DataLength))
                {
                    if(DataLength == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
                        sprintf(CharData, "%d", SQLBuffer);
                        DataLength = strlen(CharData);
                        fwrite(&DataLength, sizeof(DataLength), 1, TargetHandle);
                        fwrite(CharData, sizeof(char), DataLength, TargetHandle);
                    }
                }
            }
            else if(DataType == SQL_DOUBLE || DataType == SQL_FLOAT)
            {
                SQLDOUBLE SQLBuffer = 0;
                char CharData[32];

                if(DBGetData(StatementHandle, ColumbLoop+1, SQL_C_DOUBLE, &SQLBuffer, 32, &DataLength))
                {
                    if(DataLength == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
                        sprintf(CharData, "%f", SQLBuffer);
                        DataLength = strlen(CharData);
                        fwrite(&DataLength, sizeof(DataLength), 1, TargetHandle);
                        fwrite(CharData, sizeof(char), DataLength, TargetHandle);
                    }
                }
            }
            else{
                sprintf(StatusText, "Unknown SQL data type. Table: %s, Select Columb: %d, Type: %d", ImportTable, ColumbLoop, DataType);
                WriteLog(StatusText);
            }

            ColumbLoop++;
        }
    }

    DBCloseCursor(StatementHandle);

    LSQL.DBDisconnect();

    if(TargetHandle) fclose(TargetHandle);

    return SQL_IMPORT_RESULT_OK;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

